unit WinForm1;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, Borland.Data.Common, Borland.Data.Provider,
  System.Globalization;

type
  TWinForm1 = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    label3: System.Windows.Forms.Label;
    label2: System.Windows.Forms.Label;
    comboBox1: System.Windows.Forms.ComboBox;
    textBox2: System.Windows.Forms.TextBox;
    textBox1: System.Windows.Forms.TextBox;
    panel1: System.Windows.Forms.Panel;
    radioButton4: System.Windows.Forms.RadioButton;
    radioButton3: System.Windows.Forms.RadioButton;
    radioButton2: System.Windows.Forms.RadioButton;
    label1: System.Windows.Forms.Label;
    button1: System.Windows.Forms.Button;
    dataGrid1: System.Windows.Forms.DataGrid;
    dataSet1: System.Data.DataSet;
    LocalInterbaseConnection: Borland.Data.Provider.BdpConnection;
    bdpSelectCommand1: Borland.Data.Provider.BdpCommand;
    bdpInsertCommand1: Borland.Data.Provider.BdpCommand;
    bdpUpdateCommand1: Borland.Data.Provider.BdpCommand;
    bdpDeleteCommand1: Borland.Data.Provider.BdpCommand;
    BdpDataAdapter1: Borland.Data.Provider.BdpDataAdapter;
    BdpCommandBuilder1: Borland.Data.Provider.BdpCommandBuilder;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure button1_Click(sender: System.Object; e: System.EventArgs);
    procedure radioButton2_CheckedChanged(sender: System.Object; e: System.EventArgs);
    procedure radioButton3_CheckedChanged(sender: System.Object; e: System.EventArgs);
    procedure radioButton4_CheckedChanged(sender: System.Object; e: System.EventArgs);
    procedure TWinForm1_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    procedure SetCommandTextBox();
    procedure SetCommandBuilderUpdateMode();
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm1))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm1.InitializeComponent;
type
  TArrayOfSystem_Object = array of System.Object;
begin
  Self.label3 := System.Windows.Forms.Label.Create;
  Self.label2 := System.Windows.Forms.Label.Create;
  Self.comboBox1 := System.Windows.Forms.ComboBox.Create;
  Self.textBox2 := System.Windows.Forms.TextBox.Create;
  Self.textBox1 := System.Windows.Forms.TextBox.Create;
  Self.panel1 := System.Windows.Forms.Panel.Create;
  Self.radioButton4 := System.Windows.Forms.RadioButton.Create;
  Self.radioButton3 := System.Windows.Forms.RadioButton.Create;
  Self.radioButton2 := System.Windows.Forms.RadioButton.Create;
  Self.label1 := System.Windows.Forms.Label.Create;
  Self.button1 := System.Windows.Forms.Button.Create;
  Self.dataGrid1 := System.Windows.Forms.DataGrid.Create;
  Self.dataSet1 := System.Data.DataSet.Create;
  Self.LocalInterbaseConnection := Borland.Data.Provider.BdpConnection.Create;
  Self.bdpSelectCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.bdpInsertCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.bdpUpdateCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.bdpDeleteCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.BdpDataAdapter1 := Borland.Data.Provider.BdpDataAdapter.Create;
  Self.BdpCommandBuilder1 := Borland.Data.Provider.BdpCommandBuilder.Create;
  Self.panel1.SuspendLayout;
  (System.ComponentModel.ISupportInitialize(Self.dataGrid1)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.dataSet1)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.BdpDataAdapter1)).BeginInit;
  Self.SuspendLayout;
  // 
  // label3
  // 
  Self.label3.Location := System.Drawing.Point.Create(160, 8);
  Self.label3.Name := 'label3';
  Self.label3.TabIndex := 22;
  Self.label3.Text := 'Select Command';
  // 
  // label2
  // 
  Self.label2.Location := System.Drawing.Point.Create(8, 8);
  Self.label2.Name := 'label2';
  Self.label2.TabIndex := 21;
  Self.label2.Text := 'Update Mode';
  // 
  // comboBox1
  // 
  Self.comboBox1.Items.AddRange(TArrayOfSystem_Object.Create('Key', 'All'));
  Self.comboBox1.Location := System.Drawing.Point.Create(8, 32);
  Self.comboBox1.Name := 'comboBox1';
  Self.comboBox1.Size := System.Drawing.Size.Create(121, 21);
  Self.comboBox1.TabIndex := 20;
  // 
  // textBox2
  // 
  Self.textBox2.Location := System.Drawing.Point.Create(160, 32);
  Self.textBox2.Name := 'textBox2';
  Self.textBox2.Size := System.Drawing.Size.Create(344, 20);
  Self.textBox2.TabIndex := 19;
  Self.textBox2.Text := '';
  // 
  // textBox1
  // 
  Self.textBox1.Location := System.Drawing.Point.Create(160, 56);
  Self.textBox1.Multiline := True;
  Self.textBox1.Name := 'textBox1';
  Self.textBox1.ReadOnly := True;
  Self.textBox1.Size := System.Drawing.Size.Create(344, 112);
  Self.textBox1.TabIndex := 18;
  Self.textBox1.Text := '';
  // 
  // panel1
  // 
  Self.panel1.BackColor := System.Drawing.SystemColors.ControlDark;
  Self.panel1.Controls.Add(Self.radioButton4);
  Self.panel1.Controls.Add(Self.radioButton3);
  Self.panel1.Controls.Add(Self.radioButton2);
  Self.panel1.Controls.Add(Self.label1);
  Self.panel1.Location := System.Drawing.Point.Create(8, 56);
  Self.panel1.Name := 'panel1';
  Self.panel1.Size := System.Drawing.Size.Create(144, 112);
  Self.panel1.TabIndex := 17;
  // 
  // radioButton4
  // 
  Self.radioButton4.Location := System.Drawing.Point.Create(8, 80);
  Self.radioButton4.Name := 'radioButton4';
  Self.radioButton4.TabIndex := 8;
  Self.radioButton4.Text := 'Delete';
  Include(Self.radioButton4.CheckedChanged, Self.radioButton4_CheckedChanged);
  // 
  // radioButton3
  // 
  Self.radioButton3.Location := System.Drawing.Point.Create(8, 56);
  Self.radioButton3.Name := 'radioButton3';
  Self.radioButton3.TabIndex := 7;
  Self.radioButton3.Text := 'Insert';
  Include(Self.radioButton3.CheckedChanged, Self.radioButton3_CheckedChanged);
  // 
  // radioButton2
  // 
  Self.radioButton2.Location := System.Drawing.Point.Create(8, 32);
  Self.radioButton2.Name := 'radioButton2';
  Self.radioButton2.TabIndex := 6;
  Self.radioButton2.Text := 'Update';
  Include(Self.radioButton2.CheckedChanged, Self.radioButton2_CheckedChanged);
  // 
  // label1
  // 
  Self.label1.AutoSize := True;
  Self.label1.Location := System.Drawing.Point.Create(8, 8);
  Self.label1.Name := 'label1';
  Self.label1.Size := System.Drawing.Size.Create(85, 16);
  Self.label1.TabIndex := 0;
  Self.label1.Text := 'Command Type';
  // 
  // button1
  // 
  Self.button1.Location := System.Drawing.Point.Create(8, 408);
  Self.button1.Name := 'button1';
  Self.button1.Size := System.Drawing.Size.Create(144, 23);
  Self.button1.TabIndex := 15;
  Self.button1.Text := 'Generate Commands';
  Include(Self.button1.Click, Self.button1_Click);
  // 
  // dataGrid1
  // 
  Self.dataGrid1.CaptionForeColor := System.Drawing.SystemColors.ActiveCaptionText;
  Self.dataGrid1.DataMember := '';
  Self.dataGrid1.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.dataGrid1.ImeMode := System.Windows.Forms.ImeMode.NoControl;
  Self.dataGrid1.Location := System.Drawing.Point.Create(8, 168);
  Self.dataGrid1.Name := 'dataGrid1';
  Self.dataGrid1.RightToLeft := System.Windows.Forms.RightToLeft.No;
  Self.dataGrid1.Size := System.Drawing.Size.Create(496, 232);
  Self.dataGrid1.TabIndex := 16;
  // 
  // dataSet1
  // 
  Self.dataSet1.DataSetName := 'NewDataSet';
  Self.dataSet1.Locale := System.Globalization.CultureInfo.Create('en-US');
  // 
  // LocalInterbaseConnection
  // 
  Self.LocalInterbaseConnection.ConnectionOptions := 'waitonlocks=False;tran' +
  'saction isolation=ReadCommitted;commitretain=False;sqldialect=3;servercha' +
  'rset=;rolename=myrole';
  Self.LocalInterbaseConnection.ConnectionString := 'assembly=Borland.Data.I' +
  'nterbase,Version=2.5.0.0,Culture=neutral,PublicKeyToken=91d62ebb5b0d1b1b;' +
  'vendorclient=gds32.dll;database=localhost:C:\Program Files\Common Files\Borland Shared\Data\' +
  'employee.gdb;provider=Interbase;username=sysdba;password=masterke' +
  'y';
  // 
  // bdpSelectCommand1
  // 
  Self.bdpSelectCommand1.CommandOptions := nil;
  Self.bdpSelectCommand1.CommandText := nil;
  Self.bdpSelectCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpSelectCommand1.Connection := nil;
  Self.bdpSelectCommand1.ParameterCount := (SmallInt(0));
  Self.bdpSelectCommand1.SchemaName := nil;
  Self.bdpSelectCommand1.Transaction := nil;
  Self.bdpSelectCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // bdpInsertCommand1
  // 
  Self.bdpInsertCommand1.CommandOptions := nil;
  Self.bdpInsertCommand1.CommandText := nil;
  Self.bdpInsertCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpInsertCommand1.Connection := nil;
  Self.bdpInsertCommand1.ParameterCount := (SmallInt(0));
  Self.bdpInsertCommand1.SchemaName := nil;
  Self.bdpInsertCommand1.Transaction := nil;
  Self.bdpInsertCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // bdpUpdateCommand1
  // 
  Self.bdpUpdateCommand1.CommandOptions := nil;
  Self.bdpUpdateCommand1.CommandText := nil;
  Self.bdpUpdateCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpUpdateCommand1.Connection := nil;
  Self.bdpUpdateCommand1.ParameterCount := (SmallInt(0));
  Self.bdpUpdateCommand1.SchemaName := nil;
  Self.bdpUpdateCommand1.Transaction := nil;
  Self.bdpUpdateCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // bdpDeleteCommand1
  // 
  Self.bdpDeleteCommand1.CommandOptions := nil;
  Self.bdpDeleteCommand1.CommandText := nil;
  Self.bdpDeleteCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpDeleteCommand1.Connection := nil;
  Self.bdpDeleteCommand1.ParameterCount := (SmallInt(0));
  Self.bdpDeleteCommand1.SchemaName := nil;
  Self.bdpDeleteCommand1.Transaction := nil;
  Self.bdpDeleteCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // BdpDataAdapter1
  // 
  Self.BdpDataAdapter1.Active := False;
  Self.BdpDataAdapter1.DataSet := Self.dataSet1;
  Self.BdpDataAdapter1.DataTable := nil;
  Self.BdpDataAdapter1.DeleteCommand := Self.bdpDeleteCommand1;
  Self.BdpDataAdapter1.InsertCommand := Self.bdpInsertCommand1;
  Self.BdpDataAdapter1.SelectCommand := Self.bdpSelectCommand1;
  Self.BdpDataAdapter1.StartRecord := 0;
  Self.BdpDataAdapter1.UpdateCommand := Self.bdpUpdateCommand1;
  // 
  // BdpCommandBuilder1
  // 
  Self.BdpCommandBuilder1.DataAdapter := nil;
  Self.BdpCommandBuilder1.ExcludeFilter := nil;
  Self.BdpCommandBuilder1.QuotePrefix := '';
  Self.BdpCommandBuilder1.QuoteSuffix := '';
  Self.BdpCommandBuilder1.ReadOnly := nil;
  Self.BdpCommandBuilder1.UpdateMode := Borland.Data.Common.BdpUpdateMode.Key;
  // 
  // TWinForm1
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(512, 438);
  Self.Controls.Add(Self.label3);
  Self.Controls.Add(Self.label2);
  Self.Controls.Add(Self.comboBox1);
  Self.Controls.Add(Self.textBox2);
  Self.Controls.Add(Self.textBox1);
  Self.Controls.Add(Self.panel1);
  Self.Controls.Add(Self.button1);
  Self.Controls.Add(Self.dataGrid1);
  Self.Name := 'TWinForm1';
  Self.Text := 'Command Builder Demo';
  Include(Self.Load, Self.TWinForm1_Load);
  Self.panel1.ResumeLayout(False);
  (System.ComponentModel.ISupportInitialize(Self.dataGrid1)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.dataSet1)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.BdpDataAdapter1)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm1.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm1.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm1.TWinForm1_Load(sender: System.Object; e: System.EventArgs);
begin
  			comboBox1.SelectedIndex := 0;
end;

procedure TWinForm1.radioButton4_CheckedChanged(sender: System.Object; e: System.EventArgs);
begin
   			SetCommandTextBox;
end;

procedure TWinForm1.radioButton3_CheckedChanged(sender: System.Object; e: System.EventArgs);
begin
  			SetCommandTextBox;
end;

procedure TWinForm1.radioButton2_CheckedChanged(sender: System.Object; e: System.EventArgs);
begin
  			SetCommandTextBox;
end;

procedure TWinForm1.button1_Click(sender: System.Object; e: System.EventArgs);
var ds : DataSet;
begin

			textBox1.Text := '';

			if textBox2.Text = '' then
      begin
				textBox1.Text := 'Enter a valid Select command above';
        exit;
			end;

			try
        begin
          if LocalInterbaseConnection.State <> ConnectionState.Open then
	  				LocalInterbaseConnection.Open();

          BDPDataAdapter1 := BdpDataAdapter.Create( textBox2.Text, LocalInterbaseConnection);
	  			BDPCommandBuilder1 := BdpCommandBuilder.Create( BDPDataAdapter1 );
		  		SetCommandBuilderUpdateMode();

  				ds := DataSet.Create();
	  			BDPDataAdapter1.DataSet := ds;

		  		BDPDataAdapter1.Active := false;
			  	BDPDataAdapter1.Active := true;

  				LocalInterbaseConnection.Close();

			  	dataGrid1.SetDataBinding(ds,ds.Tables[0].TableName);

				  radioButton2.Checked := true;
  				SetCommandTextBox();

        end;
      except
        on f : Exception do
        begin
          textBox1.Text := 'Error Generating Commands. Failed with message: ' + f.Message;
        end;
      end;

end;

procedure TWinForm1.SetCommandBuilderUpdateMode();
begin

  case comboBox1.SelectedIndex of
    0:
   		BDPCommandBuilder1.UpdateMode := Borland.Data.Common.BdpUpdateMode.Key;
    1:
			BDPCommandBuilder1.UpdateMode := Borland.Data.Common.BdpUpdateMode.All;
  end;

end;

procedure TWinForm1.SetCommandTextBox();
begin

  try
    begin
    	if LocalInterbaseConnection.State <> ConnectionState.Open then
					LocalInterbaseConnection.Open();

				if BDPDataAdapter1.SelectCommand <> nil then
					if radioButton2.Checked then
						textBox1.Text := BDPCommandBuilder1.GetUpdateCommand().CommandText
					else if radioButton3.Checked then
						textBox1.Text := BDPCommandBuilder1.GetInsertCommand().CommandText
					else if radioButton4.Checked then
						textBox1.Text := BDPCommandBuilder1.GetDeleteCommand().CommandText
          else
					  textBox1.Text := 'Click Generate Command First';

				LocalInterbaseConnection.Close();

    end;
  except
    on e : Exception do
    begin
				textBox1.Text := 'An Exception has occurred: ' + e.Message;
    end;
  end;

end;


end.
